//
//  YHTravelDocsPreparationListCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHTravelDocsPreparationListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHTravelDocsPreparationListCell"
    static let cellH: CGFloat = 70
    
    var dataModel: YHTravelDocsPreparationListModel? {
        didSet {
            updataUI()
        }
    }

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_B(ofSize: 16)
        label.text = "张山"
        return label
    }()
    
    lazy var subtTitleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.text = "(港澳通行证入境)"
        return label
    }()
    
    lazy var statusLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.failColor
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "已驳回"
        return label
    }()
    
    lazy var statusImageView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "blue_right_arrow"))
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
}

private extension YHTravelDocsPreparationListCell {
    func updataUI() {
        guard let model = dataModel else { return }
        
        titleLable.text = model.name
        
        // travel_cert_type integer <int32> 证件类型 0-未知 1-护照 3-港澳通行证
        if model.travel_cert_type == 1 {
            subtTitleLable.text = "(护照入境)"
        } else if model.travel_cert_type == 3 {
            subtTitleLable.text = "(港澳通行证入境)"
        } else {
            subtTitleLable.text = ""
        }

        titleLable.textColor = .mainTextColor
        // status 缴费状态 -1-未缴费 0-待上传 1-待审核 2-已拒绝 3-已完成
        if model.status == -1 {
            statusLable.text = "未开启"
            titleLable.textColor = .mainTextColor30
            statusLable.textColor = UIColor.mainTextColor30
            statusImageView.image = UIImage(named: "disable_right_arrow")
            
        } else if model.status == 0 {
            statusLable.text = "待上传"
            statusLable.textColor = UIColor.brandMainColor
            statusImageView.image = UIImage(named: "blue_right_arrow")
            
        } else if model.status == 1 {
            statusLable.text = "审核中"
            statusLable.textColor = UIColor.warnColor
            statusImageView.image = UIImage(named: "orange_right_arrow")
            
        } else if model.status == 2 {
            statusLable.text = "已驳回"
            statusLable.textColor = UIColor.failColor
            statusImageView.image = UIImage(named: "red_right_arrow")
            
        } else if model.status == 3 {
            statusLable.text = "已完成"
            statusLable.textColor = UIColor.successColor
            statusImageView.image = UIImage(named: "green_right_arrow")
            
        } else {
            statusLable.text = "-"
            statusLable.textColor = UIColor.failColor
            statusImageView.image = UIImage(named: "red_right_arrow")
        }
    }
    
    func setupUI() {
        
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        
        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.addSubview(statusImageView)
        statusImageView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        whiteContentView.addSubview(statusLable)
        statusLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(statusImageView.snp.left)
            make.height.equalTo(20)
        }
        
        whiteContentView.addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.height.equalTo(20)
        }
        
        whiteContentView.addSubview(subtTitleLable)
        subtTitleLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(titleLable.snp.right).offset(8)
//            make.right.equalTo(statusLable.snp.left).offset(-8)
            make.height.equalTo(20)
        }
    }
}
